/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.interpreter;

import jpcsp.format.rco.vsmx.INativeFunction;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXFunction;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeFunction;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeObject;
import jpcsp.format.rco.vsmx.objects.NativeFunctionFactory;

public class VSMXMethod
extends VSMXBaseObject {
    private VSMXBaseObject object;
    private String name;
    private VSMXBaseObject thisObject;
    private int numberOfArguments;
    private VSMXBaseObject[] arguments;

    public VSMXMethod(VSMXInterpreter interpreter, VSMXBaseObject object, String name) {
        super(interpreter);
        this.object = object;
        this.name = name;
    }

    public VSMXBaseObject getObject() {
        return this.object;
    }

    public String getName() {
        return this.name;
    }

    public VSMXBaseObject getThisObject() {
        return this.thisObject;
    }

    public VSMXBaseObject[] getArguments() {
        return this.arguments;
    }

    public int getNumberOfArguments() {
        return this.numberOfArguments;
    }

    public VSMXFunction getFunction(int numberOfArguments, VSMXBaseObject[] arguments) {
        VSMXBaseObject function;
        this.numberOfArguments = numberOfArguments;
        this.arguments = arguments;
        this.thisObject = this.object.getValue();
        if (this.object.hasPropertyValue(this.name) && (function = this.object.getPropertyValue(this.name).getValue()) != null && function instanceof VSMXFunction) {
            return (VSMXFunction)function;
        }
        if (this.object instanceof VSMXFunction && "call".equals(this.name)) {
            if (numberOfArguments > 0) {
                --this.numberOfArguments;
                if (arguments.length > 0) {
                    this.thisObject = arguments[0];
                    this.arguments = new VSMXBaseObject[this.numberOfArguments];
                    System.arraycopy(arguments, 1, this.arguments, 0, this.numberOfArguments);
                }
            }
            return (VSMXFunction)this.object;
        }
        INativeFunction nativeFunction = null;
        if (this.object instanceof VSMXNativeObject) {
            VSMXNativeObject nativeObject = (VSMXNativeObject)this.object;
            nativeFunction = NativeFunctionFactory.getInstance().getNativeFunction(nativeObject, this.name, numberOfArguments);
        } else if (this.object instanceof VSMXBaseObject) {
            nativeFunction = NativeFunctionFactory.getInstance().getNativeFunction(this.object, this.name, numberOfArguments);
        }
        if (nativeFunction != null) {
            return new VSMXNativeFunction(this.interpreter, nativeFunction);
        }
        return null;
    }

    public void call(VSMXBaseObject[] arguments) {
    }

    @Override
    public String typeOf() {
        return "function";
    }

    @Override
    public String getClassName() {
        return this.name;
    }

    @Override
    public String toString() {
        return String.format("%s.%s()", this.object, this.name);
    }
}

